var SchoolApp = angular.module('SchoolApp', ['ui.router','oc.lazyLoad'])
        .config(function($stateProvider, $urlRouterProvider) {
        $urlRouterProvider.otherwise('/');
        
            $stateProvider
            .state('/', {
                url: '/',
                templateUrl: BASE_URL+'home/page_contents',
                resolve: {
                deps: ['$ocLazyLoad', function($ocLazyLoad) {
                    return $ocLazyLoad.load([{
                        name: 'SchoolApp',
                        insertBefore: '#ng_load_plugins_before', // load the above css files before '#ng_load_plugins_before'
                        files: [
                            'http://localhost/shs/assets/global/plugins/counterup/jquery.waypoints.min.js',
                            'http://localhost/shs/assets/global/plugins/counterup/jquery.counterup.min.js'
                        ]}]);
                }]
            }
            })
            .state('students', {
                url: '/students',
                templateUrl: BASE_URL+'students/students_page',
//                controller:'TodoController'
            })
            .state('students.list', {
                url: '/list',
                templateUrl: BASE_URL+'students/students_list',
                controller: function($scope) {
                    $scope.dogs = ['Bernese', 'Husky', 'Goldendoodle'];
                }
            })
            
            .state('students.paragraph', {
                url: '/paragraph',
                template: 'I could sure use a drink right now.'
            })
            
            .state('subjects', {
                    url: '/subjects',
                    views: {
                        // the main template will be placed here (relatively named)
                        '': { templateUrl: BASE_URL+'students/about'},

                        'columnOne@subjects': { template: 'Look I am a column Look I am a column Look I am a column Look I am a column !' },

                        'columnTwo@subjects': { 
                            templateUrl: BASE_URL+'students/tables',
                            controller: 'scotchController'
                        }
                    }

                });
});

//SchoolApp.controller("MyCtrl", function($ocLazyLoad) {
//  $ocLazyLoad.load('http://localhost/shs/assets/global/plugins/counterup/jquery.waypoints.min.js');
//  $ocLazyLoad.load('http://localhost/shs/assets/global/plugins/counterup/jquery.counterup.min.js');
//});

SchoolApp.controller('TodoController', function($rootScope, $scope, $http, $timeout) {
    $scope.$on('$viewContentLoaded', function() {   
        Metronic.initAjax(); // initialize core components        
    });

    // set sidebar closed and body solid layout mode
    $rootScope.settings.layout.pageSidebarClosed = true;
});


SchoolApp.controller('scotchController', function($scope) {
    $scope.message = 'test';
    $scope.scotches = [
        {
            name: 'Macallan 12',
            price: 50
        },
        {
            name: 'Chivas Regal Royal Salute',
            price: 10000
        },
        {
            name: 'Glenfiddich 1937',
            price: 20000
        }
    ];
    
});