<?php
//----------------RESIZING IMAGE STARTS HERE----------------//
class SimpleImage {
 
   var $image;
   var $image_type;
 
   function load($filename) {
 
      $image_info = getimagesize($filename);
      $this->image_type = $image_info[2];
      if( $this->image_type == IMAGETYPE_JPEG ) {
 
         $this->image = imagecreatefromjpeg($filename);
      } elseif( $this->image_type == IMAGETYPE_GIF ) {
 
         $this->image = imagecreatefromgif($filename);
      } elseif( $this->image_type == IMAGETYPE_PNG ) {
 
         $this->image = imagecreatefrompng($filename);
      }
   }
   function save($filename, $image_type=IMAGETYPE_JPEG, $compression=75, $permissions=null) {
 
      if( $image_type == IMAGETYPE_JPEG ) {
         imagejpeg($this->image,$filename,$compression);
      } elseif( $image_type == IMAGETYPE_GIF ) {
 
         imagegif($this->image,$filename);
      } elseif( $image_type == IMAGETYPE_PNG ) {
 
         imagepng($this->image,$filename);
      }
      if( $permissions != null) {
 
         chmod($filename,$permissions);
      }
   }
   function output($image_type=IMAGETYPE_JPEG) {
 
      if( $image_type == IMAGETYPE_JPEG ) {
         imagejpeg($this->image);
      } elseif( $image_type == IMAGETYPE_GIF ) {
 
         imagegif($this->image);
      } elseif( $image_type == IMAGETYPE_PNG ) {
 
         imagepng($this->image);
      }
   }
   function getWidth() {
 
      return imagesx($this->image);
   }
   function getHeight() {
 
      return imagesy($this->image);
   }
   function resizeToHeight($height) {
 
      $ratio = $height / $this->getHeight();
      $width = $this->getWidth() * $ratio;
      $this->resize($width,$height);
   }
 
   function resizeToWidth($width) {
      $ratio = $width / $this->getWidth();
      $height = $this->getheight() * $ratio;
      $this->resize($width,$height);
   }
 
   function scale($scale) {
      $width = $this->getWidth() * $scale/100;
      $height = $this->getheight() * $scale/100;
      $this->resize($width,$height);
   }
 
   function resize($width,$height) {
      $new_image = imagecreatetruecolor($width, $height);
      imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());
      $this->image = $new_image;
   }      
 
}
//----------------RESIZING IMAGE ENDS HERE----------------//




//----------------CROPPING IMAGE STARTS HERE----------------//
  //    $filename= "../../pages/hostel/hostel_pictures/".$name;
  //	list($w, $h, $type, $attr) = getimagesize($filename);
  //	$src_im = imagecreatefromjpeg($filename);
  //	
  //	$src_x = '0';   // begin x
  //	$src_y = '0';   // begin y
  //	$src_w = '100'; // width
  //	$src_h = '100'; // height
  //	$dst_x = '0';   // destination x
  //	$dst_y = '0';   // destination y
  //	
  //	$dst_im = imagecreatetruecolor($src_w, $src_h);
  //	$white = imagecolorallocate($dst_im, 255, 255, 255);
  //	imagefill($dst_im, 0, 0, $white);
  //	
  //	imagecopy($dst_im, $src_im, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h);
  //	
  //	header("Content-type: image/png");
  //	imagepng($dst_im);
  //	imagedestroy($dst_im);
//----------------CROPPING IMAGE ENDS HERE----------------//


?>